TITLE   'Bar with a Temperature Step'				{ exa181x.pde }
SELECT     errlim=1e-3
COORDINATES
   cartesian1
VARIABLES   temp
DEFINITIONS
   Lx=1.0     heat=0     k=82     rcp=7.87e3*449 		{ Iron }
   tempi=300     temp0=400		{ Initial and boundary temperatures }
   fluxd_x=-k*dx(temp)		{ Component fluxd_x }
   temp_ex=(tempi-temp0)*erf[ x/(2*sqrt(k*t/rcp))]+temp0   	
INITIAL VALUES
   temp=tempi
EQUATIONS
  dx( fluxd_x)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain'
   start (0)  point value(temp)=temp0  line to (Lx)  		{ Temperature for t> 0 }
TIME   from 0 to 3000
PLOTS
   for t=100 by 100 to 3000
   elevation( temp, temp_ex) from (0) to (Lx)
END


